import { IActionParam, MainControl, UIUtil, IParam, isExistAndNotEmpty } from '@core';
import { TabViewPanelControlProps } from './tab-view-panel-control-prop';
import { TabViewPanelControlState } from './tab-view-panel-control-state';

/**
 * @description 分页视图面板部件
 * @export
 * @class TabViewPanelControl
 * @extends {MainControl}
 */
export class TabViewPanelControl extends MainControl {
  /**
   * @description 部件状态
   * @type {FormControlState}
   * @memberof TabViewPanelControl
   */
  public declare state: TabViewPanelControlState;

  /**
   * 部件输入参数
   *
   * @type {TabViewPanelControlProps}
   * @memberof TabViewPanelControl
   */
  public declare props: TabViewPanelControlProps;

  /**
   * 设置部件状态
   *
   * @memberof TabViewPanelControl
   */
  public setState() {
    super.setState();
    this.state.parentView = this.props.parentView;
  }

  /**
   * 获取导航参数数据
   *
   * @private
   * @param {string} key 标识
   * @return {*} 
   * @memberof TabViewPanelControl
   */
  private getNavParamValue(key: string) {
    const { parentView, context, viewParams } = this.state;
    const data = parentView?.state?.viewCtx?.viewGlobal || {};
    if (isExistAndNotEmpty(data[key])) {
      return data[key];
    } else if (isExistAndNotEmpty(context[key])) {
      return context[key];
    } else if (isExistAndNotEmpty(viewParams[key])) {
      return viewParams[key];
    }
    return null;
  }

  /**
   * 支持导航参数的处理
   *
   */
  public useNavParams() {
    const { navContexts, navParams, navFilter, appDeCodeName, navPSDer } = this.state;
    const { context, viewParams } = toRefs(this.state);
    //  处理导航关系
    if (navPSDer && navPSDer.major && navPSDer.majorKey) {
      const value = this.getNavParamValue(navPSDer.majorKey) || this.getNavParamValue(navPSDer.major);
      if (isExistAndNotEmpty(value)) {
        Object.assign(context.value, { [navPSDer.major]: value });
      }
    }

    //  处理导航过滤项
    if (navFilter && appDeCodeName) {
      const value = this.getNavParamValue(appDeCodeName.toLowerCase());
      if (isExistAndNotEmpty(value)) {
        Object.assign(context.value, { [`n_${navFilter}_eq`]: value });
      }
    }

    // 处理导航上下文
    if (navContexts && Object.keys(navContexts).length > 0) {
      const _context = UIUtil.computedNavData({}, context.value, viewParams.value, navContexts);
      Object.assign(context.value, _context);
    }

    // 处理导航视图参数
    if (navParams && Object.keys(navParams).length > 0) {
      const _param = UIUtil.computedNavData({}, context.value, viewParams.value, navParams);
      Object.assign(viewParams.value, _param);
    }
  }

  /**
   * 部件事件
   *
   * @param {IActionParam} actionParam
   * @memberof TabViewPanelControl
   */
  public onViewEvent(actionParam: IActionParam) {
    const { tag, action, data } = actionParam;
    const { controlName } = this.state;
  }

  /**
   * @description 安装部件所有功能模块的方法
   * @return {*}
   * @memberof TabViewPanelControl
   */
  public moduleInstall() {
    const superParams = super.moduleInstall();
    this.useNavParams();
    return {
      ...superParams,
      onViewEvent: this.onViewEvent.bind(this)
    };
  }
}
